package ru.yandex.direct.oneshot.oneshots.updategeotargeting

import ru.yandex.direct.ytwrapper.model.YtField

class CampaignWithShardTableRow : ConvertibleTableRow<CampaignWithShard>(listOf(SHARD, CAMPAIGN_ID)) {
    val shard: Int
        get() = valueOf(SHARD)
    val campaignId: Long
        get() = valueOf(CAMPAIGN_ID)

    companion object {
        private val SHARD = YtField("shard", Int::class.java)
        private val CAMPAIGN_ID = YtField("cid", Long::class.java)
    }

    override fun convert(): CampaignWithShard {
        return CampaignWithShard(shard, campaignId)
    }
}

data class CampaignWithShard(
    val shard: Int,
    val campaignId: Long
)
