package ru.yandex.direct.oneshot.oneshots.updateuser

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.user.repository.UserRepository
import ru.yandex.direct.dbschema.ppc.enums.UsersRepType
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.sharding.ShardKey
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

data class InputData(
    val repType: UsersRepType,
    val userIds: List<Long>
)

/**
 * Для списка пользователей заполняет указанный тип представителя
 * Входные данные:
 * - repType - тип представителя вида: chief, main или limited
 * - userIds - список id пользователей вида: [1, 2, 3, ...]
 */
@Component
@Approvers("gerdler", "bratgrim", "a-dubov")
@Multilaunch
class UpdateUserRepTypeOneshot @Autowired constructor(
    private val shardHelper: ShardHelper,
    private val userRepository: UserRepository
) : SimpleOneshot<InputData, Void> {
    override fun validate(inputData: InputData): ValidationResult<InputData, Defect<Any>> {
        return ValidationResult.success(inputData)
    }

    override fun execute(inputData: InputData, prevState: Void?): Void? {
        shardHelper.groupByShard(inputData.userIds, ShardKey.UID)
            .forEach { shard, uids -> userRepository.updateRepTypeByUid(shard, uids, inputData.repType)}
        return null
    }

}

