package ru.yandex.direct.oneshot.oneshots.yttables

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.postviewofflinereport.repository.PostViewOfflineReportYtRepository
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig
import ru.yandex.direct.ytwrapper.YtUtils
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator
import ru.yandex.inside.yt.kosher.cypress.YPath
import ru.yandex.yt.ytclient.proxy.request.CreateNode
import ru.yandex.yt.ytclient.proxy.request.MountTable
import ru.yandex.yt.ytclient.proxy.request.ObjectType
import java.time.Duration

@Component
@Multilaunch
@Approvers("gerdler", "darkkeks", "ppalex")
class CreateTableForPostViewReportsOneshot(
    private val ytProvider: YtProvider,
    private val ytConfig: DirectYtDynamicConfig,
) : SimpleOneshot<Void, Void> {
    companion object {
        val LOGGER: Logger = LoggerFactory.getLogger(CreateTableForPostViewReportsOneshot::class.java)
    }

    override fun validate(inputData: Void?): ValidationResult<Void, Defect<Any>> {
        return ValidationResult.success(inputData)
    }

    override fun execute(inputData: Void?, prevState: Void?): Void? {
        val tablePath = ytConfig.tables().direct().postViewOfflineReportTasksTablePath()
        val ytCluster = ytConfig.postViewOfflineReportYtClusters.iterator().next()
        val operator = ytProvider.getDynamicOperator(ytCluster)
        val createNodeReq = CreateNode(tablePath, ObjectType.Table)
            .setRecursive(true)
            .addAttribute("dynamic", true)
            .addAttribute(YtUtils.SCHEMA_ATTR, PostViewOfflineReportYtRepository.Companion.TASKS_TABLE_SCHEMA.toYTree())
        operator.runRpcCommandWithTimeout(operator.ytClient::createNode, createNodeReq)
        LOGGER.info("Executed CreateNode on $tablePath")

        YtDynamicOperator.getWithTimeout(
            operator.ytClient.mountTableAndWaitTablets(MountTable(YPath.simple(tablePath))),
            Duration.ofSeconds(40),
            "Failed to mount table $tablePath"
        )
        LOGGER.info("Table $tablePath mounted")
        return null
    }
}
