package ru.yandex.direct.oneshot.util

import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import ru.yandex.direct.oneshot.oneshots.CampaignMigrationBaseOneshot.Companion.GsonStateDeserializer
import ru.yandex.direct.oneshot.oneshots.CampaignMigrationBaseOneshot.Companion.State
import java.lang.reflect.Type
import java.time.LocalDate
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter

class GsonUtils {
    companion object {
        val DATE_TIME_FORMAT: DateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")
        val DATE_FORMAT: DateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd")

        @JvmStatic
        val GSON: Gson = GsonBuilder()
            .registerTypeAdapter(LocalDateTime::class.java, GsonLocalDateTimeDeserializer())
            .registerTypeAdapter(LocalDateTime::class.java, GsonLocalDateTimeSerializer())
            .registerTypeAdapter(LocalDate::class.java, GsonLocalDateDeserializer())
            .registerTypeAdapter(LocalDate::class.java, GsonLocalDateSerializer())
            .registerTypeAdapter(State::class.java, GsonStateDeserializer())
            .registerTypeAdapter(Void::class.java, GsonLVoidDeserializer())
            .create()
    }

    class GsonLocalDateTimeDeserializer : JsonDeserializer<LocalDateTime> {
        override fun deserialize(json: JsonElement, typeOfT: Type, context: JsonDeserializationContext): LocalDateTime =
            LocalDateTime.parse(json.asString, DATE_TIME_FORMAT)
    }

    class GsonLocalDateTimeSerializer : JsonSerializer<LocalDateTime> {
        override fun serialize(src: LocalDateTime, typeOfSrc: Type, context: JsonSerializationContext): JsonElement =
            JsonPrimitive(DATE_TIME_FORMAT.format(src))
    }

    class GsonLocalDateDeserializer : JsonDeserializer<LocalDate> {
        override fun deserialize(json: JsonElement, typeOfT: Type, context: JsonDeserializationContext): LocalDate =
            LocalDate.parse(json.asString, DATE_FORMAT)
    }

    class GsonLocalDateSerializer : JsonSerializer<LocalDate> {
        override fun serialize(src: LocalDate, typeOfSrc: Type, context: JsonSerializationContext): JsonElement =
            JsonPrimitive(DATE_FORMAT.format(src))
    }

    class GsonLVoidDeserializer : JsonDeserializer<Void> {
        override fun deserialize(json: JsonElement, typeOfT: Type, context: JsonDeserializationContext): Void? = null
    }
}
