package ru.yandex.direct.oneshot.util

import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.ItemValidationBuilder
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtTable

class ValidateUtil {
    companion object {
        fun <I> validateTableExistsInYt(
            ytProvider: YtProvider,
            validator: ItemValidationBuilder<I, Defect<*>>,
            ytCluster: YtCluster,
            tablePath: String
        ): ValidationResult<I, Defect<*>> {
            validator.item(ytCluster, "ytCluster")
                .check(CommonConstraints.notNull())
            if (validator.result.hasAnyErrors()) return validator.result

            validator.item(tablePath, "tablePath")
                .check(CommonConstraints.notNull())
                .check(Constraint.fromPredicate({ tableName -> ytProvider.getOperator(ytCluster).exists(YtTable(tableName)) },
                    CommonDefects.objectNotFound())
                )

            return validator.result
        }
    }
}
