package ru.yandex.direct.oneshot.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneshotExecuteTaskMonitor implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OneshotExecuteTaskMonitor.class);

    private static final List<OneshotExecuteTask<?, ?, ?>> activeTasks = Collections.synchronizedList(new ArrayList<>());

    private final OneshotExecuteTask<?, ?, ?> oneshotExecuteTask;

    public OneshotExecuteTaskMonitor(OneshotExecuteTask<?, ?, ?> oneshotExecuteTask) {
        this.oneshotExecuteTask = oneshotExecuteTask;
    }

    @Override
    public void run() {
        activeTasks.add(oneshotExecuteTask);
        try {
            oneshotExecuteTask.run();
        } catch (Exception e) {
            logger.error("unexpected exception in oneshot execution task", e);
        }
        activeTasks.remove(oneshotExecuteTask);
        ExecutionWorker.removeTaskInProgress(oneshotExecuteTask);
    }

    public static void shutdownTasks() {
        synchronized (activeTasks) {
            for (var task : activeTasks) {
                task.setShutdown(true);
            }
        }
    }
}
