package ru.yandex.direct.oneshot.worker;

import com.google.common.reflect.TypeToken;
import one.util.streamex.EntryStream;
import org.springframework.context.ApplicationContext;

import ru.yandex.direct.oneshot.worker.def.BaseOneshot;
import ru.yandex.direct.oneshot.worker.def.ShardedOneshot;
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot;

@SuppressWarnings("UnstableApiUsage")
public class WorkerUtils {

    public static BaseOneshot findOneshotBeanByClassName(ApplicationContext appContext,
                                                         String className) {
        return EntryStream.of(appContext.getBeansOfType(BaseOneshot.class))
                .mapToKey((beanName, bean) -> bean.getClass().getCanonicalName())
                .toMap()
                .get(className);
    }

    @SuppressWarnings("unchecked")
    public static <T extends BaseOneshot<V>, V> TypeToken<V> detectOneshotInputDataType(T oneshot) {
        TypeToken<? extends BaseOneshot> typeToken = TypeToken.of(oneshot.getClass());
        return (TypeToken<V>) typeToken.resolveType(BaseOneshot.class.getTypeParameters()[0]);
    }

    @SuppressWarnings("unchecked")
    public static <T extends SimpleOneshot<V, S>, V, S> TypeToken<S> detectSimpleOneshotStateDataType(T oneshot) {
        TypeToken<? extends SimpleOneshot> typeToken = TypeToken.of(oneshot.getClass());
        return (TypeToken<S>) typeToken.resolveType(SimpleOneshot.class.getTypeParameters()[1]);
    }

    @SuppressWarnings("unchecked")
    public static <T extends ShardedOneshot<V, S>, V, S> TypeToken<S> detectShardedOneshotStateDataType(T oneshot) {
        TypeToken<? extends ShardedOneshot> typeToken = TypeToken.of(oneshot.getClass());
        return (TypeToken<S>) typeToken.resolveType(ShardedOneshot.class.getTypeParameters()[1]);
    }
}
