package ru.yandex.direct.oneshot.worker.def;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Количество повторов, если обработка чанка в потоке заканчивается эксепшеном.
 * Перед каждым повтором ждем timeoutSeconds, 30 секунд по умолчанию
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Retries {
    int DEFAULT_TIMEOUT_SECONDS = 30;

    int value();
    int timeoutSeconds() default DEFAULT_TIMEOUT_SECONDS;
}
