#!/bin/bash

# wait for unified agent
while ! curl http://localhost:16301/status > /dev/null 2>&1; do sleep 1; done

PROFILE=devtest
SECRET_SUFFIX=""
SECRETS_DIR=/etc/direct-tokens

case "$1" in 
    dev7)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.dev7.json
        )
        # TODO PROFILE, SECRET_SUFFIX, MONGO_SECRET_SUFFIX -- в YP.Lite определены только для development
        ;;
    devtest)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.devtest.json
        )
        PROFILE=devtest
        SECRET_SUFFIX="-test"
        MONGO_SECRET_SUFFIX="-devtest"
        ;;
    testing)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.test.json
        )
        PROFILE=test
        SECRET_SUFFIX="-test"
        MONGO_SECRET_SUFFIX="-test"
        ;;
    production)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/db-config.json
        )
        PROFILE=production
        ;;
esac

function get_secret() {
    cat "$SECRETS_DIR/$1$SECRET_SUFFIX"
}

function get_mongo_secret() {
    cat "$SECRETS_DIR/$1$MONGO_SECRET_SUFFIX"
}

export DIRECT_AUTH_TOKEN=`get_secret direct_auth_token_canvas`
export INTERNAL_API_TOKEN=`get_secret internal_api_token_canvas`
export FILE_API_INTERNAL_TOKEN=`get_secret file_api_internal_token_canvas`
export MDS_AUTH_TOKEN=`get_secret mds_canvas`
export MONITORING_TOKEN=`get_secret monitoring_canvas`
export SANDBOX_HOOK_SECRET=`get_secret sandbox_hook_secret_canvas`
export SANDBOX_OAUTH_TOKEN=`get_secret sandbox_oauth_token_canvas`
export MONGODB_CONNECTION_STRING=`get_mongo_secret mongo_canvas`

JAVA_HOME=/usr/local/yandex-direct-jdk11

if [[ ! -z "$USE_JDK17" ]] && [[ -d /usr/local/yandex-direct-jdk17 ]]; then
    JAVA_HOME=/usr/local/yandex-direct-jdk17
fi

JAVA_ADDITIONAL_ARGS+=(
    -Dnetwork_config=zk:///direct/network-config.json
)

JAVA_OPTS=(
    -Xmx4G
    -Dfile.encoding=UTF-8
    -Djava.net.preferIPv4Stack=false
    -Djava.net.preferIPv6Addresses=true
    -Dlog4j2.formatMsgNoLookups=true
    -Dsun.net.inetaddr.ttl=60
    -Dsun.net.inetaddr.negative.ttl=0
    -Dsun.awt.fontconfig=/usr/local/yandex-direct-jdk11/lib/fonts/fontconfig.properties
    -Xlog:gc*=info,safepoint=info,age*=trace:file=/var/log/yandex/direct-canvas.gc.log:time,uptime,level,tags:filecount=5,filesize=100M
    -XX:+CrashOnOutOfMemoryError
    -XX:+HeapDumpOnOutOfMemoryError
    -XX:HeapDumpPath=/var/log/yandex/direct-canvas.hprof
)

JAVA_ARGS=(
    -cp /var/www/direct-canvas/direct-canvas/*:
    -Dport=10184
    -Djava.library.path=/var/www/direct-canvas/direct-canvas
    -Dhealth_checker.enable_cache=true
    -Dlog4j.configurationFile=/etc/direct/canvas/logging-config/log4j2-deploy.xml
    -Dspring.profiles.active="$PROFILE"
    ru.yandex.canvas.Application
    --log-configs-directory /etc/direct/canvas/logging-config/
)

$JAVA_HOME/bin/java ${JAVA_OPTS[@]} ${JAVA_ADDITIONAL_ARGS[@]} ${JAVA_ARGS[@]}
