#!/bin/bash

# wait for unified agent
while ! curl http://localhost:16301/status > /dev/null 2>&1; do sleep 1; done

case "$1" in 
    dev7)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.dev7.json
        )
        ;;
    devtest)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.devtest.json
        )
        ;;
    testing)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.test.json
        )
        ;;
    production)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/db-config.json
        )
        ;;
esac

JAVA_ADDITIONAL_ARGS+=(
    -Dnetwork_config=zk:///direct/network-config.json
)


JAVA_OPTS=(
    -Xmx4G
    -Dfile.encoding=UTF-8
    -Djava.net.preferIPv4Stack=false
    -Djava.net.preferIPv6Addresses=true
    -Dsun.net.inetaddr.ttl=60
    -Dsun.net.inetaddr.negative.ttl=0
    -Xlog:gc*=info,safepoint=info,age*=trace:file=/var/log/yandex/direct-chassis.gc.log:time,uptime,level,tags:filecount=5,filesize=100M
    -XX:+CrashOnOutOfMemoryError
    -XX:+HeapDumpOnOutOfMemoryError
    -XX:HeapDumpPath=/var/log/yandex/direct-chassis.hprof
)

JAVA_ARGS=(
    -cp /var/www/direct-chassis/direct-chassis/*:
    -Djava.library.path=/var/www/direct-chassis/direct-chassis
    -Dlog4j.configurationFile=/etc/direct/chassis/logging-config/log4j2-deploy.xml
    ru.yandex.direct.chassis.app.ChassisApp
    --log-configs-directory /etc/direct/chassis/logging-config
)

/usr/local/yandex-direct-jdk11/bin/java ${JAVA_OPTS[@]} ${JAVA_ADDITIONAL_ARGS[@]} ${JAVA_ARGS[@]}
