#!/bin/sh

# wait for unified agent
while ! curl http://localhost:16301/status > /dev/null 2>&1; do sleep 1; done

PATH=/sbin:/usr/sbin:/bin:/usr/bin
CWD=/var/www/direct-intapi
VERSION=`cat /var/www/direct-intapi/version`
GC_LOG=/var/log/yandex/direct-intapi.gc.log
JAVA=/usr/local/yandex-direct-jdk11/bin/java

case "$1" in
    production) MEM_OPTS="-Xmx26G -Xms26G";;
    *) MEM_OPTS="-Xmx4G";;
esac
case "$1" in
    dev7)
        DB_CONFIG_OPTS="-Ddb_config=zk:///direct/np/db-config/db-config.dev7.json"
        ;;
    devtest)
        DB_CONFIG_OPTS="-Ddb_config=zk:///direct/np/db-config/db-config.devtest.json"
        ;;
    testing)
        DB_CONFIG_OPTS="-Ddb_config=zk:///direct/np/db-config/db-config.test.json"
        ;;
    production)
        DB_CONFIG_OPTS="-Ddb_config=zk:///direct/db-config.json"
        ;;
esac
JAVA_OPTS="$MEM_OPTS $DB_CONFIG_OPTS \
    -Dnetwork_config=zk:///direct/network-config.json \
    -Dfile.encoding=UTF-8 \
    -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true \
    -Dlog4j2.formatMsgNoLookups=true \
    -Dsun.net.inetaddr.ttl=60 -Dsun.net.inetaddr.negative.ttl=0 \
    -Djava.util.Arrays.useLegacyMergeSort=true \
    -XX:ActiveProcessorCount=10 \
    -XX:-UsePerfData \
    -XX:+UseG1GC \
    -XX:MaxGCPauseMillis=100 \
    -Xlog:gc*=info,safepoint=info,age*=trace:file=$GC_LOG:time,uptime,level,tags:filecount=8,filesize=100M \
    -XX:+CrashOnOutOfMemoryError \
    -XX:+HeapDumpOnOutOfMemoryError \
    -XX:-OmitStackTraceInFastThrow \
    -XX:HeapDumpPath=/var/log/yandex/direct-intapi.hprof"
PROG_OPTS="--log-configs-directory /etc/direct/intapi/logging-config"
CLASSPATH="/var/www/direct-intapi/hotfix/$VERSION/classes/:/var/www/direct-intapi/direct-intapi/*:"

if [[ -v DEPLOY_NODE_DC ]]; then
    DC_OPTS="-Ddirect.dc=$DEPLOY_NODE_DC"
else
    DC_OPTS=""
fi

JAVA_ARGS="$JAVA_OPTS $DC_OPTS -cp $CLASSPATH -Djava.library.path=/var/www/direct-intapi/direct-intapi -Dlog4j.configurationFile=/etc/direct/intapi/logging-config/log4j2-deploy.xml ru.yandex.direct.intapi.IntapiApp $PROG_OPTS"

# jvm can't append data to previous log, so copy logs to archive
for log in "$GC_LOG"*; do
    test -f "$log" && cat "$log" >>`dirname "$GC_LOG"`/arc.`basename "$GC_LOG"`.`date +%Y%m%d` && rm "$log"
done

cd "$CWD"
exec "$JAVA" $JAVA_ARGS
