#!/bin/bash -e
export PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
mkdir -p /var/log/solomon-agent

find /usr/local/share/dt_solomon -name '*.pyc' -delete || true

case $1 in
production)
    config_name=direct-main.conf
    ;;
*)
    config_name=direct-main.testing.conf
    ;;
esac

ulimit -v $((2*1024*1024))
/usr/local/solomon-agent/solomon-agent --config /etc/solomon-agent/$config_name
