#!/usr/bin/perl

use uni::perl;
use FindBin '$Bin';

use Yandex::HTTP;
use File::Slurp;

use Log::Any '$log';
use Log::Any::Adapter "Stderr";



my $BASE_URL = "http://geoexport.yandex.ru/";
#my $BASE_URL = "http://g.ararat-lucid.dev.yandex.ru/";

my $BASE_PARAM = {
    format => 'pm',
#    types => '0,1,2,3,4,5,6,7,8,9,10,11,12,13,14',
};
my $DST_PATH = "$Bin/../lib";

my %GB = (
    ru  => { new_parents => '977:225' },
    ua  => { new_parents => '977:187' },
    api => { new_parents => '977:10000' },
);

while (my ($suff, $param) = each %GB) {
    $log->info("Processing <$suff>");
    my %param = (%$BASE_PARAM, %$param);
    $param{pm_pkg_suffix} = $suff  if $suff;
    my $url = Yandex::HTTP::make_url($BASE_URL, \%param);
    
    $log->trace("GET $url");
    my $data = http_get $url  or die "Failed to get $url";
    # fix unescaped apostrophes; remove after LIB-198
    # $data =~ s/('[^'\n]*)(?='[^'\n]*')/$1\\/gxms;

    $log->trace("checking");
    eval $data  or die "Bad code: $@";

    $log->trace("saving");
    my $dst_file = "$DST_PATH/geobase" . ($suff ? "_$suff" : q{}) . ".pm";
    write_file $dst_file, {binmode => ":utf8"}, $data;
}


