#!/bin/bash

set -e

TMP=`mktemp -d`

echo "Fetch geobase..."
# wget -O lib/geobase.pm 'http://geoexport.yandex.ru/geobase-ua.pm'; perl -p -i.bak -e 's/package geobase_ua;/package geobase;/' lib/geobase.pm
# wget -O lib/geobase.pm 'http://geoexport.yandex.ru/?format=pm&new_parents=977%3A187'
# NB!Если для теста нужно изменить родителей в нескольких регионах, то указываем через запятую <регион>:<новый родитель>,<регион>:<новый родитель>, ...
# Пример:
# wget -O lib/geobase.pm 'http://geoexport.yandex.ru/?format=pm&new_parents=977%3A187%2C163%3A159'
curl -o $TMP/geobase.pm 'http://geoexport.yandex.ru/?format=pm&new_parents=977%3A187'

echo "Upload to Sandbox..."
ya upload --do-not-remove --json-output $TMP/geobase.pm >$TMP/upload_result.json

echo "Get resource id..."
RESOURCE_ID=$(jq -s .[0].resource_id <$TMP/upload_result.json)

echo "Update pkg_inc.json..."
cat >"geobase_pkg_inc.json" <<EOF
{
  "meta": {
    "name": "geobase",
    "maintainer": "Sergey Zhuravlev <zhur@yandex-team.ru>"
  },
  "data": [
    {
      "source": {
        "type": "SANDBOX_RESOURCE",
        "id": ${RESOURCE_ID}
      },
      "destination": {
        "path": "/usr/share/perl5/geobase.pm"
      }
    }
  ]
}
EOF

echo "Done."


