#!/bin/bash

set -e

TMP=`mktemp -d`

echo "Download async-profiler..."
# last release from https://github.com/jvm-profiling-tools/async-profiler/releases
curl -L -o $TMP/async-profile.tar.gz https://github.com/jvm-profiling-tools/async-profiler/releases/download/v1.6/async-profiler-1.6-linux-x64.tar.gz 

echo "Unarchive..."
mkdir $TMP/async-profiler
tar -C $TMP/async-profiler -xzf $TMP/async-profile.tar.gz

echo "Upload to Sandbox..."
ya upload --tar --do-not-remove --json-output $TMP/async-profiler >$TMP/upload_result.json

echo "Get resource id..."
RESOURCE_ID=$(jq -s .[0].resource_id <$TMP/upload_result.json)

echo "Update pkg_inc.json..."
cat >"async-profiler_pkg_inc.json" <<EOF
{
  "meta": {
    "name": "async-profiler",
    "maintainer": "Sergey Zhuravlev <zhur@yandex-team.ru>"
  },
  "data": [
    {
      "source": {
        "type": "SANDBOX_RESOURCE",
        "id": ${RESOURCE_ID},
        "path": "async-profiler",
        "untar": true
      },
      "destination": {
        "path": "/usr/local/java-async-profiler"
      }
    }
  ]
}
EOF

echo "Done."


