#!/bin/bash

set -e

if [[ $(uname) != 'Linux' ]]; then
    echo "You should compile jattach only under Linux"
    exit 1
fi

TMP=`mktemp -d`

echo "Checkout repo..."
git clone git@github.com:apangin/jattach.git $TMP/jattach

echo "Make..."
make -C $TMP/jattach

echo "Upload to Sandbox..."
ya upload --tar --do-not-remove --json-output $TMP/jattach/build/jattach >$TMP/upload_result.json

echo "Get resource id..."
RESOURCE_ID=$(jq -s .[0].resource_id <$TMP/upload_result.json)

echo "Update pkg_inc.json..."
cat >"jattach_pkg_inc.json" <<EOF
{
  "meta": {
    "name": "jattach",
    "maintainer": "Sergey Zhuravlev <zhur@yandex-team.ru>"
  },
  "data": [
    {
      "source": {
        "type": "SANDBOX_RESOURCE",
        "id": ${RESOURCE_ID},
        "untar": true
      },
      "destination": {
        "path": "/usr/local/bin/"
      }
    }
  ]
}
EOF

echo "Done."


