#!/bin/bash

set -e

TMP=`mktemp -d`

echo "Checkout repo..."
git clone git@github.com:JetBrains/intellij-community.git $TMP/intellij-community --depth=1

echo "Build..."
pushd $TMP/intellij-community/plugins/java-decompiler/engine/
# gradle 4.0 does not support jdk11, gradle 4.10.3 fails test for some reason
sed -i '' 's/4.0/5.0/' gradle/wrapper/gradle-wrapper.properties
./gradlew build
popd

echo "Upload to Sandbox..."
ya upload --tar --do-not-remove --json-output $TMP/intellij-community/plugins/java-decompiler/engine/build/libs/fernflower.jar >$TMP/upload_result.json

echo "Get resource id..."
RESOURCE_ID=$(jq -s .[0].resource_id <$TMP/upload_result.json)

echo "Update pkg_inc.json..."
cat >"fernflower_pkg_inc.json" <<EOF
{
  "meta": {
    "name": "fernflower",
    "maintainer": "Vyacheslav Boben <darkkeks@yandex-team.ru>"
  },
  "data": [
    {
      "source": {
        "type": "SANDBOX_RESOURCE",
        "id": ${RESOURCE_ID},
        "untar": true
      },
      "destination": {
        "path": "/usr/lib/fernflower/"
      }
    }
  ]
}
EOF

echo "Done."

