# coding=utf-8

def system_pull_config():
    return { 'System': {
        'Cpu': 'ADVANCED',
        'Memory': 'ADVANCED',
        'Network': 'ADVANCED',
        'Storage': 'ADVANCED',
        'Io': 'ADVANCED',
        'Kernel': 'ADVANCED',
    }}


def python2_pull_config(file_path, module_name, class_name, params={}):
    config = {
        'FilePath': file_path,
        'ModuleName': module_name,
        'ClassName': class_name,
    }
    if params:
        config['Params'] = params
    return { 'Python2': config }


def service_config(project, service, modules, labels=[], pull_interval='15s'):
    return {
        'Project': project,
        'Service': service,
        'PullInterval': pull_interval,
        'Labels': labels,
        'Modules': modules
    }

