# coding=utf-8

import os
import json
import re
import sys
from subprocess import check_output, STDOUT

def json_loads_byteified(json_text):
    return _byteify(json.loads(json_text, object_hook=_byteify), ignore_dicts=True)

def _byteify(data, ignore_dicts=False):
    if isinstance(data, unicode):
        return data.encode('utf-8')
    if isinstance(data, list):
        return [ _byteify(item, ignore_dicts=True) for item in data ]
    if isinstance(data, dict) and not ignore_dicts:
        return { _byteify(key, ignore_dicts=True): _byteify(value) for key, value in data.iteritems() }
    return data


class DtConfigLoader:
    def __init__(self, logger, **params):
        self._logger = logger
        self._logprefix = self.__class__.__name__
        self._logger.info(self._logprefix + ' - new instance with params={}'.format(params))

        self._params = params

    def my_log(self, msg):
        self._logger.info('%s: %s' % (self._logprefix, msg))

    def load(self):
        modules_dir = self._params['pull_modules_dir']
        self.my_log('loading modules from ' + modules_dir)

        configs = []
        for module in os.listdir(modules_dir):
            if not re.match('^[a-z_]+\.py$', module):
                self.my_log('skipping file ' + module)
                continue

            module_file = modules_dir + '/' + module
            module_pkg = os.path.basename(modules_dir)
            service = module[0:-3].replace('_', '-')

            # нужно просто получить текстовый конфиг с путем к модулю и именем класса
            # загружать тут весь модуль вместе с pull-классами не хочу - он будет загружен потом agent'ом
            # но конфиг хочется держать рядом с модулем - поэтому считаем, что при запуске он отдаст его в json
            out = None
            try:
                cmd = ['/usr/bin/python2', module_file, module_file, module_pkg, service]
                self.my_log('loading from cmd: %s' % cmd)
                out = check_output(cmd, stderr=STDOUT)
                m_configs = json_loads_byteified(out) # agent'у нужен байтовый конфиг
            except Exception as e:
                self.my_log('loading %s failed with %s %s, output: %s' % (module_file, type(e), e, out))
                continue

            self.my_log('%s loaded: %s' % (module_file, m_configs))
            configs.extend(m_configs)

        self.my_log('all modules loaded')
        return configs
