#!/usr/bin/env python
# coding=utf-8
"""
Специфичные для Директа системные метрики
"""

from datetime import datetime as dt
from subprocess import check_output, STDOUT

# после загрузки агент не перечитывает класс, но можно выгрузить его через applicable и загрузить обратно
class TcpSessionsPullModule:
    def __init__(self, logger, registry, **params):
        #self._reads = registry.counter({'request_type': 'READ'})
        #self._writes = registry.counter({'request_type': 'WRITE'})
        self._logger = logger
        self._logprefix = self.__class__.__name__
        self.my_log('new instance with params={}'.format(params))

    def my_log(self, msg):
        self._logger.info('%s: %s' % (self._logprefix, msg))

    def pull(self, ts, consumer):
        self.my_log('start pull method with utc timestamp %s' % (dt.utcfromtimestamp(ts / 1000.0).strftime('%Y-%m-%d %H:%M:%S')))

        # рабочий однострочник уже был для графита. Простите
        cmd = ['/usr/bin/perl', '-le', 'BEGIN { $timeout = 10; $interval = 2; }; $s = time(); while (time() - $s < $timeout) { @ss = map { s/^\s+//; s/\s+/ /g; $_ } split(/\n/, qx(ss -atn | grep -v State | cut -d" " -f1 | sort | uniq -c)); map { ($num, $state) = split; $states{$state} += $num } @ss; sleep $interval; } END { while (($state, $cnt) = each %states) { $cnt = $cnt * $interval / $timeout; $state =~ s/[^0-9a-zA-Z]/_/g; $state = lc $state; print "$state $cnt" } }']
        try:
            out = check_output(cmd, stderr=STDOUT)
        except CalledProcessError as e:
            self.my_log('cmd output: ' + e.output)
            raise

        consumed_sensors = 0
        for line in out.split('\n'):
            try:
                state, value = line.strip().split()
                value = float(value)
            except:
                continue # ошибки парсинга - это обычно норма, просто игнорим

            consumer.gauge({'sensor': 'tcp_sessions', 'tcp_state': state}, ts, value)
            consumed_sensors += 1

        self.my_log('end pull method, %d sensors consumed' % consumed_sensors)


def applicable():
    return True


# эта часть выполняется только при генерации конфигов (запускается системным python)
# и никак не связана со сбором метрик (запускается встроенным solomon-agent python)
if __name__ == '__main__':
    import sys
    import json

    sys.path.extend(['share/dt_solomon', '/usr/local/share/dt_solomon'])
    from dts_common import service_config, python2_pull_config, system_pull_config

    # пути к файлу и директории - параметры подставит генератор конфига
    file_path = sys.argv[1]
    module_pkg = sys.argv[2]
    # имя сервиса генерируется из имени файла, для my_module.py будет my-module
    service = sys.argv[3]

    if not applicable():
        print '{}'
        sys.exit(0)

    config = [
        # "контейнер" для однотипных сенсоров https://wiki.yandex-team.ru/solomon/userguide/datamodel/
        # solomon будет забирать сенсоры по hostname:.../...?project=...&service=...
        service_config(
            service=service,
            project='direct', 
            pull_interval='15s',
            modules=[
                python2_pull_config(file_path, module_pkg, "TcpSessionsPullModule", params={}) # тут можно передать специфичные параметры, например, какие метрики нужны на данном хосте
            ],
            labels=[] # общие метки для всех модулей, почти никогда не нужны
        ),
        service_config('direct', 'sys', [system_pull_config()]) # встроенные железные метрики (эту часть не надо копипастить =)
    ]

    print json.dumps(config)
