#!/usr/bin/perl

=pod

    $Id$

=head1 NAME

    ./api/bin/api5_units.pl

=head1 SYNOPSIS

    ./api5_units.pl --user-id 123455

=head1 DESCRIPTION

    Скрипт показывает баллы по пользователю в API5

=head1 METHODS

=cut

use Direct::Modern;

use feature 'say';

use Yandex::DBTools;

use my_inc '../../', for => 'api/services/v5';

use Settings;
use UnitsFactory;
use API::Authorization::User;
use API::Authorization;
use API::PSGI::Base;
use API::Request::JSON;

use ScriptHelper;

my $uid;
extract_script_params(
    'user-id:i' => \$uid,
);
$uid or die usage();

my $user = API::Authorization::User->new($uid);
die "client not found" unless $user->client_id;

print_user_info($user);
my $login = $user->login;
my $auth = API::Authorization->fake_new( $uid, $login, { chief_rep_user => $user, operator_user => $user, karma => 0 });

my $brand_chief_rep_user = $auth->get_brand_chief_rep_user_by_clientid($user->ClientID);
my $bucket_info = API::PSGI::Base->get_units_bucket($user, $login, $auth);
if ($brand_chief_rep_user) {
    say "\nClient is under brand, brand info:";
    print_user_info($brand_chief_rep_user);
}

my $units = UnitsFactory::create(
    $bucket_info->id,
    $bucket_info->limit
);

my $stat_flds = [qw/total_sum_rub active_28days_sum_rub daily_spent_rub_estimate/];
my $money_stat = get_all_sql(PPC(ClientID => $user->client_id), [
    "select " . join(', ', 'type', @$stat_flds) . ' from clients_stat',
    where => {clientid => $user->client_id}
]);

if($units->limit) {
    say "\nlimit: " . $units->limit;
    say 'balance: ' . $units->balance;
    say 'spent: ' . $units->spent;
    foreach my $st (@$money_stat) {
        say qq~\nmoney statistic for $st->{type}:\n~ . join("\n",
            map { sprintf("\t$_: %.2f", $st->{$_}) } @$stat_flds
        );
    }
} else {
    die 'Units storage unavailable';
}

say "\nto check logs for units comsumption use command: ";
say "\tdscribe-grep.pl --type ppclog_api --today --cluid $uid --less --api_version 5  | logskim.pl -w -e 'p(qw/log_time cmd uid cluid units_stats/)' | less";

sub print_user_info {
    my $user = shift;
    say "ClientID: " . $user->client_id . "\tuid: " . $user->id . "\tlogin: " . $user->login;

    # m dt:ppc:all 'select api5_units_daily from clients_api_options where clientid = 9644213'
    say "\tAPI5 calculated units: " . ($user->api5_units_daily||'undef') . ' # clients_api_options.api5_units_daily';
    say "\tAPI user manualy set units limit: " . ($user->api_units_daily||0) . ' # (users_api_options.api_units_daily on uid)';
}
