package API::Authorization::CheckToken;

use Direct::Modern;

use TextTools qw/normalize_login/;

use Yandex::Blackbox qw/bb_oauth_token $BB_LOGIN/;

use API::Authorize::PersistentToken qw/check_token/;
use Settings; #$Settings::API_SERVER_PATH

=head2 authorize($token, $reqid, $auth_res)
    Проверяет валидность токена, возвращает хэш
    {
        uid => $uid,
        login => $login,
        application_id => $app_id
    } в случае успеха авторизации
    возвращает undef в случае провала
    В случае недоступности blackbox падает (желательно ловить исключение)
=cut

sub authorize {
    my $self = shift;
    my $token = shift or die "no token specified";
    my $reqid = shift;
    my $auth_res = shift;

    # проверяем токен в oauth
    $auth_res //= Yandex::Blackbox::bb_oauth_token($token, $ENV{REMOTE_ADDR} || '127.0.0.1', $Settings::API_SERVER_PATH, [$BB_LOGIN], undef, $reqid);

    return unless $auth_res->{status} eq 'VALID'; # undef auth failed
    my $login = $auth_res->{'dbfield'}{$BB_LOGIN};

    # проверяем список допустимых прав
    unless (
        $auth_res->{scope}
        && scalar grep {
            $auth_res->{scope}{$_}
        } ('direct:api', 'direct:api-1month', 'direct:api-3month')
    ) {
        return; # undef auth failed
    }

    $login = normalize_login($login);

    return {
        uid => $auth_res->{uid},
        login => $login,
        application_id => $auth_res->{client_id},
    }; # auth ok
}

=head2 authorize_by_persistent_token($token, $remote_addr)
    Проверяет валидность постоянного токена
    При успешной авторизации возвращает хэш
    {
        uid => $uid,
        login => $login,
        application_id => $app_id
    },
    в ином случае возвращает undef
=cut

sub authorize_by_persistent_token {
    my ($self, $token, $remote_addr) = @_;

    return check_token($token, $remote_addr);
}

1;
