package API::Authorization::MouseIpType;

use Mouse;
use Mouse::Util::TypeConstraints;

my $IPV6_RE = qr/(
    ([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}
    |([0-9a-fA-F]{1,4}:){1,7}:
    |([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}
    |([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}
    |([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}
    |([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}
    |([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}
    |[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})
    |:((:[0-9a-fA-F]{1,4}){1,7}
    |:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}
    |::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]
    |(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]
    |(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]
    |(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]
    |(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))/x;

my $IPV4_RE = qr/(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/;

subtype 'ip'
    => as 'Str',
    => where { $_ =~ $IPV4_RE || $_ =~ $IPV6_RE }
    => message { ($_||'') . ' not a valid ip' };

__PACKAGE__->meta->make_immutable();

1;
