package API::Authorization::RBAC::LoginCheck;

use Direct::Modern;

=pod

=encoding utf8

    $Id$

=head1 NAME

    API::Authorization::RBAC::LoginCheck

=head1 DESCRIPTION

    Обертка над rbac_login_check

=head1 METHODS

=cut

use RBAC2::DirectChecks qw/rbac_login_check/;
use IpTools qw/is_internal_ip/;
use API::Authorization::RBAC::LoginCheck::Rights;

use Mouse;
use API::Authorization::MouseIpType;

has user => (
    is => 'ro',
    isa => 'API::Authorization::User',
    required => 1,
);

has remote_address => (
    is => 'ro',
    isa => 'ip',
    required => 1,
);

has _authenticate_and_retrieve_rights_result => (
    is => 'ro',
    isa => 'ArrayRef',
    lazy => 1,
    default => sub {
        my $self = shift;
        return [ $self->_authenticate_and_retrieve_rights ];
    }
);

has error_code => (
    is => 'ro',
    isa => 'Maybe[Int]',
    lazy => 1,
    default => sub {
        my $self = shift;
        return $self->_authenticate_and_retrieve_rights_result->[0];
    }
);

has rbac_rights => (
    is => 'ro',
    isa => 'API::Authorization::RBAC::LoginCheck::Rights',
    lazy => 1,
    default => sub {
        my $self = shift;
        return API::Authorization::RBAC::LoginCheck::Rights->new(
            $self->_authenticate_and_retrieve_rights_result->[1]
        );
    }
);

=head2 authenticated_ok

    true если аунтефикация не вернула ошибок

=cut

sub authenticated_ok {
    return shift->error_code?0:1;
}

sub _authenticate_and_retrieve_rights {
    my $self = shift;

    my $rbac_login_rights;

    my $rbac_res = rbac_login_check(
        undef,
        {
            UID => $self->user->uid,
            user_info => {
                # is_developer => $self->user->is_developer,
                # is_super_manager => $self->user->is_super_manager,
                # FIXME проверить для чего это было нужно и почему этого больше нет
                # В оригинальном коде в APICommon в user_info никогда не попадают 
                # is_developer и is_super_manager, их просто нет в списке 
                # запрашиваемых полей в вызове get_user_data
            },
            is_internal_ip => is_internal_ip($self->remote_address),
        },
        \$rbac_login_rights
    );
    return ($rbac_res, $rbac_login_rights);


}

__PACKAGE__->meta->make_immutable();

1;
