package API::Authorization::RBAC::LoginCheck::Rights;

use strict;
use warnings;
use utf8;

use RBACDirect; # %ROLE_NAMES
use Mouse;
use Mouse::Util::TypeConstraints;

=example
 'rbac_login_rights' => {
                       'ClientID' => undef,
                       'Login' => 1,
                       'ViewMediaplan' => 1,
                       'ViewPdfReports' => 1,
                       'can_block_karma' => 0,
                       'client_have_agency' => 1,
                       'dont_show_new_camp_link_in_menu' => 0,
                       'is_any_client' => 1,
                       'is_client_chief' => 1,
                       'is_internal_user' => 0,
                       'passport_karma_block' => 0,
                       'role' => 'client',
                       'user_allow_pay' => 1
 }
=cut

subtype 'RBACDirectRole'
  => as 'Str'
  => where { $RBACDirect::ROLE_NAMES{$_} }
  => message { ($_||'') . " not a valid RBAC role" };

has role => (
    is => 'ro',
    isa => 'RBACDirectRole',
    required => 1,
);

my @FLAGS = qw/
    Login
    ViewMediaplan
    ViewPdfReports
    client_have_agency
    dont_show_new_camp_link_in_menu
    is_any_client
    is_client_chief
    is_internal_user
    user_allow_pay
/; #FIXME наверное не все это нам нужно, хорошо бы выкинуть лишнее

foreach my $flag (@FLAGS) {
    has $flag => (
        is => 'ro',
        isa => 'Bool'
    );
}

__PACKAGE__->meta->make_immutable();

1;

