package API::Authorization::TokenFormat;

use Direct::Modern;

my $TOKEN_RE = qr/^[a-zA-Z\-\.\_\~\+\/0-9]+\=*$/;

=pod

=encoding utf8

    $Id:$

=head1 NAME

    API::Authorization::TokenFormat

=head1 SYNOPSIS

    if( API::Authorization::TokenFormat::is_valid_token('aaaaa') ) {
        say "authorization ok";
    } else {
        say "authorization failed";
    }

=head1 DESCRIPTION

    Модуль для проверки токена на соответствие RFC6750 https://tools.ietf.org/html/rfc6750
    В котором описывается как должен выглядеть токен в конструкции http заголовка вида
    Authorization: Bearer $token

=head1 METHODS

=head2 is_valid_token($token)

    True если токен $token (строка) соответствует формату, кроме как на формат
    токен ни на что не валидируется

=cut

sub is_valid_token {
    my $token = shift;
    return $token =~ $TOKEN_RE ? 1 : 0;
}

1;
