package API::Converter::ConvertMap;

use strict;
use warnings;
use utf8;

use Carp;

use Mouse;

=head2 method
    Метод схему которого нужно использовать
=cut

has method => (
    is => 'ro', isa => 'Str', required => 1,
);

=head2 to_internal_map
    Набор правил для приобразования полей из внешнего представления во внутреннее
=cut

has to_internal_map => (
    is => 'ro',
    isa => 'HashRef',
    default => sub { $_[0]->build_to_internal_map(@_) }
);

=head2 to_external_map
    Набор правил для приобразования полей из внутреннего представления во внешнее
=cut

has to_external_map => (
    is => 'ro',
    isa => 'HashRef',
    default => sub { $_[0]->build_to_external_map(@_) }
);

around [qw(to_internal_map to_external_map)] => sub {
    my $orig = shift;
    my $self = shift;
    my $map = $self->$orig(@_);
    croak "map for method ".$self->method." is not found" unless $map;
    return $map;
};

=head2 build_to_internal_map

    Конструктор правил из запроса в модели

=cut

sub build_to_internal_map {
    return {};
}

=head2 build_to_external_map

    Конструктор правил из моделей в запрос

=cut

sub build_to_external_map {
    return {};
}

__PACKAGE__->meta->make_immutable();

1;

__END__
