package API::Exception::Base;
use Mouse;

use Scalar::Util 'blessed';

use Direct::Errors::Messages;

has reason => ( is => 'ro', isa => 'Direct::Defect' );

__PACKAGE__->meta->make_immutable();

sub raise {
    my ( $class, $reason ) = @_;

    unless ( blessed $reason && $reason->isa('Direct::Defect') ) {
        $reason = error_ServerFailed($reason);
    }

    die $class->new( reason => $reason );
}

sub TO_JSON {
    my ($self) = @_;
    return {
        _class => ref $self,
        reason => $self->reason,
    };
}

1;
