package API::Exception::IllegalResponse;
use Direct::Modern;
use parent 'API::Exception::Base';

=head1 NAME

API::Exception::IllegalRequest

=head1 DESCRIPTION

Это исключение надо порождать, когда ответ сервиса невозможно сериализовать
для отправки клиенту в соответствии с протоколом, например, если в нём нет
данных, которые в XSD помечены как обязательные.

Обработчик сделает из него ответ клиенту "у нас что-то пошло не так"
и запишет сообщение в журнал ошибок. Обычно такой случай означает ошибку
программирования, которую надо поправить.

=head1 SYNOPSIS

API::Exception::IllegalResponse->raise(error_BadRequest(...));

=cut

1;
