package API::PSGI::JSON;

# $Id$

=head1 NAME

    API::PSGI::JSON;

=head1 DESCRIPTION

    Базовый JSON PSGI приложение большого API

=cut

use Direct::Modern;

use Yandex::Trace;

use WSDL::JSON::Validate;

use API::Request::JSON;

use base qw/API::PSGI::Base/;

sub cmd_type { 'JSON-API' }

sub init_request {
    my ($self, $plack_request) = @_;
    my $profile = Yandex::Trace::new_profile('api:json:init_request');
    return API::Request::JSON->new($plack_request, $self->services);
}

sub operation_response {
    my ($self, $service, $operation, $response_data) = @_;
    my $profile = Yandex::Trace::new_profile('api:json:make_response');

    return { json => {
        result => WSDL::JSON::Validate::validate(
            "$service.$operation response",
            $self->services->json_schema_response($service, $operation),
            $response_data)
    } };
}

sub client_fault {
    my ($self, $error) = @_;
    $self->log->add_error_info($error);
    return {
        json => {
            error => {
                request_id => $self->request->id . '',
                error_code => $error->code + 0,
                error_string => $error->text,
                error_detail => $self->remove_disallowed_letters($error->description)
            }
        }
    };
}

sub server_fault {
    my ($self, $error) = @_;
    $self->units_bucket_manager->is_server_fault(1);
    $self->log->add_error_info($error);
    return {
        json => {
            error => {
                request_id =>  Yandex::Trace::current_span_id() . '',
                error_code => $error->code + 0,
                error_string => $error->text,
                error_detail => $error->description,
            }
        }
    };
}

1;
