package API::PSGI::Reports::JSON;

# $Id: XML.pm 142404 2017-05-15 08:41:03Z lightelfik $

=head1 NAME

    API::PSGI::XML;

=head1 DESCRIPTION

    Базовое XML PSGI приложение большого API

=cut

use Direct::Modern;

use JSON;
use Plack::Builder;

use Yandex::Trace;

use API::Request::ReportsJSON;
use API::PSGI::Reports::OperationResponser;

use base qw/API::PSGI::JSON/;

sub init_request {
    my ($self, $plack_request) = @_;
    my $profile = Yandex::Trace::new_profile('api:json:init_request');
    return API::Request::ReportsJSON->new($plack_request, $self->services);
}

sub operation_response {
    my ($self, $service, $operation, $response_data) = @_;
    my $profile = Yandex::Trace::new_profile('api:json:make_response');

    return API::PSGI::Reports::OperationResponser::do_response($self, $response_data);
}

sub client_fault {
    my ($self, $error) = @_;
    return $self->_fault_response($error);
}

sub server_fault {
    my ($self, $error) = @_;
    return $self->_fault_response($error);
}

sub _fault_response {
    my ($self, $error) = @_;
    $self->log->add_error_info($error);

    return {
        code => $self->error_name_to_http_code($error),
        content_type => 'text/json',
        data => $self->_to_json($self->_error($error)),
    };
}

sub _to_json {
    my ($self, $json_data) = @_;
    state $json_encoder = JSON->new()->utf8;
    return $json_encoder->encode($json_data);
}

sub _error {
    my ($self, $error) = @_;

    return {
        error => {
            request_id => Yandex::Trace::current_span_id() . '',
            error_code => $error->code,
            error_string => $error->text,
            error_detail => $self->remove_disallowed_letters($error->description)
        }
    };
}

1;
