package API::PSGI::Reports::OperationResponser;

use Direct::Modern;

=pod

=encoding utf8

    $Id:$

=head1 NAME

    API::PSGI::Reports::OperationReponse

=head1 SYNOPSIS

    API::PSGI::Reports::OperationReponse->do_response($self, $response_data)

=head1 DESCRIPTION

    Общий между json/xml метод для формирования ответа в нужном формате, может
    вернуть ошибку, также выставляет заголовки

=head1 METHODS

=cut

use HTTP::Status qw/:constants/;

use Direct::Errors::Messages;

=head2 do_response($reports_psgi, $response_data)

    $reports_psgi - API::PSGI::Reports::JSON или API::PSGI::Reports::JSON объект
    $response_data - hashref с ответом от API::Service::Reports::create

    Отдает ответ сервиса в нужном формате и выставляет нужные заголовки в $reports_psgi

=cut

sub do_response {
    my ($reports_psgi, $response_data) = @_;

    if ($response_data->{type} eq 'tsv') {
        return { content_type => 'text/tab-separated-values; charset=utf-8', exists $response_data->{body} ? (data => $response_data->{body}) : (), callback => $response_data->{callback} };
    } elsif ($response_data->{type} eq 'mds') {
        return { content_type => 'text/tab-separated-values; charset=utf-8', reverse_proxy_redirect => $response_data->{url} };
    } elsif ($response_data->{type} eq 'queued' || $response_data->{type} eq 'not_ready') {
        return { content_type => 'text/json', data => $response_data->{body}, code => $response_data->{type} eq 'queued' ? HTTP_CREATED : HTTP_ACCEPTED };
    } else {
        return $reports_psgi->server_fault(error_OperationFailed);
    }
}

1;
