package API::PSGI::Reports::XML;

# $Id$

=head1 NAME

    API::PSGI::XML;

=head1 DESCRIPTION

    Базовое XML PSGI приложение большого API

=cut

use Direct::Modern;

use Plack::Builder;
use Try::Tiny;
use XML::LibXML;

use Yandex::Trace;

use API::Request::XML;
use API::PSGI::Reports::OperationResponser;

use base qw/API::PSGI::Base/;

sub cmd_type { 'XML-API' }

sub _wrap {
    my ($self, $app) = @_;

    return builder {
        $self->SUPER::_wrap($app);
    };
}

=head2 init_service($service_name)

    Инициализирует объект сервиса оп имени

=cut

sub init_service {
    my $self = shift;
    my $service_name = shift or return;

    my $service;
    try {
        $service = $self->services->init($service_name);
    } catch {
        warn "service $service_name not loaded: $_";
    };

    return $service;
}

sub init_request {
    my ($self, $plack_request) = @_;
    my $profile = Yandex::Trace::new_profile('api:xml:init_request');
    return API::Request::XML->new($plack_request, $self->services);
}

sub operation_response {
    my ($self, $service, $operation, $response_data) = @_;
    my $profile = Yandex::Trace::new_profile('api:xml:make_response');

    return API::PSGI::Reports::OperationResponser::do_response($self, $response_data);
}

sub client_fault {
    my ($self, $error) = @_;
    return $self->_xml_fault($error);
}

sub server_fault {
    my ($self, $error) = @_;
    return $self->_xml_fault($error);
}

sub _xml_fault {
    my ($self, $error) = @_;
    $self->log->add_error_info($error);

    return {
        code => $self->error_name_to_http_code($error),
        content_type => 'text/xml',
        data => $self->_error_to_xml($error),
    };
}

sub _error_to_xml {
    my ($self, $error ) = @_;

    my $xml_reply = XML::LibXML::Document->new('1.0', 'UTF-8');
    my $writer = API::Request::XML::get_xsd_writer('yandex');
    my $data = {
        requestId => Yandex::Trace::current_span_id(),
        errorCode => $error->code,
        errorMessage => $error->text,
        errorDetail => $self->remove_disallowed_letters($error->description)
    };

    $xml_reply->setDocumentElement( $writer->( $xml_reply, { ApiError => $data } ) );

    return $xml_reply->toString();
}

1;
