package API::Request::Headers;

use Direct::Modern;

=pod

    $Id:$

=head1 NAME

    API::Request::Headers

=head1 SYNOPSIS

    my $headers = API::Request::Headers->new();
    $headers->processingMode('auto'); добавлем заголовок processingMode
    $headers->returnMoneyInMicros('false'); добавлем заголовок returnMoneyInMicros

    my %headers = %{$headers->to_hash()};


=head1 DESCRIPTION

    Класс для хранения http-заголовков запроса

=head1 METHODS

=cut

use Mouse;
use Mouse::Util::TypeConstraints;


has processingMode => (
    is => 'rw',
    isa => 'Maybe[Str]',
    predicate => "has_processingMode",
);

has returnMoneyInMicros => (
    is => 'rw',
    isa => 'Maybe[Str]',
    predicate => "has_returnMoneyInMicros",
);

has skipReportHeader => (
    is => 'rw',
    isa => 'Maybe[Str]',
    predicate => "has_skipReportHeader",
);

has skipColumnHeader => (
    is => 'rw',
    isa => 'Maybe[Str]',
    predicate => "has_skipColumnHeader",
);

has skipReportSummary => (
    is => 'rw',
    isa => 'Maybe[Str]',
    predicate => "has_skipReportSummary",
);

=head2 to_array

    Преобразует объект в массив http-заголовков

=cut

sub to_array {
    my $self = shift;
    my @array = ();
    push @array, 'processingMode' => $self->processingMode if $self->has_processingMode;
    push @array, 'returnMoneyInMicros' => $self->returnMoneyInMicros if $self->has_returnMoneyInMicros;
    push @array, 'skipReportHeader' => $self->skipReportHeader if $self->has_skipReportHeader;
    push @array, 'skipColumnHeader' => $self->skipColumnHeader if $self->has_skipColumnHeader;
    push @array, 'skipReportSummary' => $self->skipReportSummary if $self->has_skipReportSummary;

    return \@array;
}

=head2 to_hash

    Преобразует объект http-заголовков в хеш

=cut

sub to_hash {
    my $self = shift;
    my @pairs = @{$self->to_array};
    my %hash = @pairs;
    return \%hash;
}


__PACKAGE__->meta->make_immutable();

1;
