package API::Request::JSON;

use strict;
use warnings;
use utf8;

use JSON;
use Try::Tiny;

use Yandex::I18n;

use Mouse;
extends 'API::Request';

use WSDL::JSON::Validate;

use API::Version;
use Direct::Errors::Messages;

=pod

    $Id$

=head1 NAME

    API::Request::JSON

=head1 SYNOPSIS

    # см базовый класс L<API::Request>

=head1 DESCRIPTION

    Класс для работы с JSON-запросом, наследован от API::Request

=head1 METHODS

=cut

has protocol => (is => 'ro', isa => 'Str', default => sub { 'json' });

has json => (is => 'ro', isa => 'Object', default => sub {
     JSON->new->utf8;
});

sub _parse_request {
    my ($self) = @_;

    my $parsed;

    try {
        $parsed = $self->json->decode($self->content);
    } catch {
        warn $_ if $API::Version::is_development;
        die error_BadRequest(iget("Невозможно обработать JSON"));
    };

    my $operation = $self->_parsed_method($parsed)
        or die error_BadRequest(iget('Операция не задана'));

    $self->service_operation_check_or_die($operation);

    $parsed->{params} = WSDL::JSON::Validate::validate(
        'params',
        $self->_services->json_schema_request(
            $self->service_name, $operation),
        $parsed->{params}
    );

    unless( defined $self->_parsed_params($parsed) ) {
        die error_BadRequest( iget('params не задан') );
    }

    return $parsed;
}

has params => (is => 'ro', lazy => 1, default => sub {
    my $self = shift;
    return $self->_parsed_params($self->_parsed);
});

has operation => (is => 'ro', lazy => 1, default => sub {
    my $self = shift;
    return $self->_parsed_method($self->_parsed);
});

sub _parsed_method { $_[1]->{method} }
sub _parsed_params { $_[1]->{params} }

__PACKAGE__->meta->make_immutable();

1;
