package API::Request::ReportsJSON;

use Direct::Modern;

use JSON;
use Try::Tiny;

use Yandex::I18n;

use Mouse;
extends 'API::Request::JSON';

use WSDL::JSON::Validate;
use XML::Compile::Schema;

use API::Version;
use API::WSDLFiles qw/xsd_definitions/;
use Direct::Errors::Messages;

=pod

    $Id: JSON.pm 140900 2017-04-18 14:31:11Z andy-ilyin $

=head1 NAME

    API::Request::JSON

=head1 SYNOPSIS

    # см базовый класс L<API::Request>

=head1 DESCRIPTION

    Класс для работы с JSON-запросом, наследован от API::Request

=head1 METHODS

=cut

use constant API_VERSION => 5;
use constant REPORT_DEFINITION_ELEMENT => 'ReportDefinition';

has protocol => (is => 'ro', isa => 'Str', default => sub { 'json' });

has json => (is => 'ro', isa => 'Object', default => sub {
     JSON->new->utf8; # ->convert_blessed for XML::NIL
});

=head2 schema

    XML::Compile::Schema объект для reports.xsd и general.xsd

=cut

sub schema {
    state $schema = XML::Compile::Schema->new( [ grep {/\b(reports|general)\b/} xsd_definitions(API_VERSION) ] );
    return $schema;
}

sub _validation_schema {
    my $self = shift;
    state $validation_schema = WSDL::JSON::Schema
        ->new($self->schema->namespaces, 'http://api.direct.yandex.com/v5/reports')
        ->build(REPORT_DEFINITION_ELEMENT);
    return $validation_schema;
}

sub _parse_request {
    my ($self) = @_;


    my $request_data = $self->_plack_request->content;
    die error_BadRequest( iget('Параметры отчета не заданы') ) unless $request_data;

    my $parsed;
    try {
        $parsed = $self->json->decode($request_data);
    } catch {
        warn $_ if $API::Version::is_development;
        die error_BadRequest(iget("Невозможно обработать JSON"));
    };

    unless(defined $parsed->{params}) {
        die error_BadRequest( iget('params не задан') );
    }

    $parsed->{method} = 'create';

    $parsed->{params} = WSDL::JSON::Validate::validate(
        params => $self->_validation_schema,
        $parsed->{params}
    );

    return $parsed;
}

__PACKAGE__->meta->make_immutable();

1;
