package API::Request::SOAPAction;

use Direct::Modern;

=pod

=encoding utf8

    $Id$

=head1 NAME

    API::Request::SOAPAction

=head1 SYNOPSIS

    my $soap_action = API::Request::SOAPAction->new("http://api.direct.yandex.ru/v5/ads/update/");
    say $soap_action->url; # http://api.direct.yandex.ru/v5/ads/update
    say $soap_action->service; # ads
    say $soap_action->operation; # update

=head1 DESCRIPTION

    Объектная обертка над SOAPAction для разбора строки и доступа к частям url-я в виде методов

=head1 METHODS

=cut

=head2 new($soap_action_string)

    По строке-заголовку SOAPAction создает объект

=cut

sub new {
    my $class = shift;
    my $url = shift;

    my $self = {
        action_url => $url
    };

    $url=~ s/\/+$//;
    my @path = split('/', $url);

    $self->{operation} = $path[-1];
    $self->{service} = $path[-2];

    return bless $self, $class;
}

=head2 url

    SOAPAction строка целиком, без последнего / если был

=cut

sub url { shift->{action_url} }

=head2 operation

    Имя метода сервиса к которому обращаемся

=cut

sub operation { shift->{operation} }

=head2 service

    Имя сервиса из SOAPAction

=cut

sub service { shift->{service} }

1;

