package API::Response::Headers;

use Direct::Modern;

=pod

    $Id:$

=head1 NAME

    API::Response::Headers

=head1 SYNOPSIS

    my $headers = API::Response::Headers->new();
    $headers->reportsInQueue(5); добавлем заголовок reportsInQueue
    $headers->retryIn(10); добавлем заголовок retryIn

    my %headers = %{$headers->to_hash()};


=head1 DESCRIPTION

    Класс для хранения http-заголовков ответа

=head1 METHODS

=cut

use Mouse;
use Mouse::Util::TypeConstraints;


has RequestId => (
    is => 'rw',
    isa => 'Str',
    predicate => "has_RequestId",
);

has Units => (
    is => 'rw',
    isa => 'Str',
    predicate => "has_Units",
);

has UnitsUsedLogin => (
    is => 'rw',
    isa => 'Str',
    predicate => "has_UnitsUsedLogin",
);

has reportsInQueue => (
    is => 'rw',
    isa => 'Int',
    predicate => "has_reportsInQueue",
);

has retryIn => (
    is => 'rw',
    isa => 'Int',
    predicate => "has_retryIn",
);

=head2 to_array

    Преобразует объект в массив http-заголовков

=cut

sub to_array {
    my $self = shift;
    my @array = ();
    push @array, 'Units' => $self->Units if $self->has_Units;
    push @array, 'Units-Used-Login' => $self->UnitsUsedLogin if $self->has_UnitsUsedLogin;
    push @array, 'RequestId' => $self->RequestId if $self->has_RequestId;
    push @array, 'reportsInQueue' => $self->reportsInQueue if $self->has_reportsInQueue;
    push @array, 'retryIn' => $self->retryIn if $self->has_retryIn;

    return \@array;
}

=head2 to_hash

    Преобразует объект http-заголовков в хеш

=cut

sub to_hash {
    my $self = shift;
    my @pairs = @{$self->to_array};
    my %hash = @pairs;
    return \%hash;
}


__PACKAGE__->meta->make_immutable();

1;
