package API::Service::CampaignsAvailabilityChecker::ResultItem::NotFound;

use Direct::Modern;

=pod

=encoding utf8

    $Id$

=head1 NAME

    API::Service::CampaignsAvailabilityChecker::ResultItem

=head1 SYNOPSIS

    my $checker = API::Service::CampaignsAvailabilityChecker::ResultItem::NotFound->new(cid => 123);

    if (!$camp_check->is_available) {
        $item->add_error(
            $camp_check->get_error(
                not_found => error_NotFound_Campaign(),
                not_supported => error_NotSupported_CampaignType(),
                archived => error_BadStatus_ArchivedCampaign(),
            )
        );
    }

=head1 DESCRIPTION

    Класс для хранения результата проверки доступности кампании в случае, если кампания не найдена.

=cut

use Mouse;

has cid => (is => 'ro', isa => 'Int', required => 1);
has is_found => (is => 'ro', isa => 'Bool', default => 0); # кампания найдена в клиентском шарде
has is_visible => (is => 'ro', isa => 'Bool', default => 0); # клиент имеет какой-то доступ к кампании
has is_available => (is => 'ro', isa => 'Bool', default => 0); # клиент имеет указанный тип доступа к кампании

__PACKAGE__->meta->make_immutable;

1;
