package API::Service::ResultSet::Indexed;

use strict;
use warnings;
use utf8;

use base qw/API::Service::ResultSet::Base/;

sub ids {
    my $self = shift;
    my $last = $#$self;
    return (0..$last);
}

sub get {
    my $self = shift;
    my $id = shift;
    return $self->[$id];
}

sub list_ok_ids {
    my $self = shift;
    return grep { !$self->[$_]->has_errors } 0..$#$self;
}

sub import {
    my $pkg = shift;
    return unless $pkg eq __PACKAGE__;
    my $caller = caller(0);
    no strict 'refs';
    $pkg->add_isa_to_subclass($caller);
}


1;

__END__
