package API::Service::ResultSet::Item;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    API::Service::ResultSet::Item

=head1 SYNOPSIS

    use_example

=head1 DESCRIPTION

    desc

=head1 METHODS

=cut

use Mouse;

has index => (
    is => 'ro',
    required => 1
);

has object => (
    is => 'ro',
#   может быть скаляром в случае если передается Id-шник
#   isa => 'Ref', # HashRef or Object tbh
    required => 1
);

has [ qw/warnings errors/ ] => (
    is => 'ro',
    isa => 'ArrayRef',
    default => sub { [] }
);

has flags_hashref => (
    is => 'ro',
    isa => 'HashRef',
    default => sub { {} },
);

sub BUILDARGS {
    my $class  = shift;
    my $index  = shift;
    my $object = shift;
    return { index => $index, object => $object };
}

=head2 new($object) 

    Создает Item для объекта

=head2 mark($flagname) 

    Уставновить флаг на объект

=cut

sub mark { shift->_set_flag($_[0], 1) }

=head2 unmark($flagname) 

    Снять флаг с объекта

=cut

sub unmark { shift->_set_flag($_[0], 0) }

=head2 has_flag($flagname) -> Bool

    True если флаг уставновлен иначе false

=cut
sub has_flag { shift->flags_hashref->{$_[0]} }

=head2 list_errors -> @errors

    Возвращает массив ошибок

=cut
sub list_errors { @{shift->errors} }

=head2 list_warnings -> @warnings

    Возвращает массив ворнингов

=cut

sub list_warnings { @{shift->warnings } }

=head2 has_warnings -> Bool

    Возвразает истину если объект имеет предупреждения

=cut

sub has_warnings { return scalar @{shift->warnings} }

=head2 has_errors -> Bool

    Возвразает истину если объект имеет ошибки

=cut
sub has_errors { return scalar @{shift->errors} }


=head2 add_error($error)

    Добавить ошибку на объект

=cut

sub add_error {
    my $self = shift;
    my $error = shift;
    push @{$self->errors}, $error;
}

=head2 add_warning($warning)

    Добавить предупреждение на объект

=cut

sub add_warning {
    my $self = shift;
    my $warning = shift;
    push @{$self->warnings}, $warning;
}


sub _set_flag {
    my $self = shift;
    my $flag = shift;
    my $value = shift;
    $self->flags_hashref->{$flag} = $value;
}

__PACKAGE__->meta->make_immutable();

1;

__END__
