package API::Services::Singleton;

use Direct::Modern;

=pod

=encoding utf8

    $Id:$

=head1 NAME

    API::Services::Singleton

=head1 SYNOPSIS

    my $services = $API::Services::Singeton::get_for_version(5);

=head1 DESCRIPTION

    Синглтон оберта над API::Services для предзагруки схем WSDL и JSON один раз на все сервисы

=head1 METHODS

=cut

use Carp qw/croak/;

use API::WSDLFiles qw/wsdl_files xsd_definitions/;
use API::Services;

my $SERVICES_BY_VERSION = {};

=head2 get_for_version($version)

    $version - целое положительное число. Версия API
    Метод возвращает API::Services для указанной версии API и кэширует его, для
    последующий вызовов

=cut

sub get_for_version {
    my $version = shift or croak "Version not specified";
    return $SERVICES_BY_VERSION->{$version} //= API::Services->new(
        [ wsdl_files($version) ],
        [ xsd_definitions($version) ]
    );
}


1;

__END__
