package API::Test::Reports::Fields;
use Direct::Modern;

=head1 NAME

API::Test::Reports::Fields

=head1 DESCRIPTION

Общие описания полей для разных юнит-тестов reports. Описания полей,
которые используются только в одном тесте, должны быть в тестах.

=cut

use parent 'Exporter';

use API::Test::Reports::Xsd qw( get_enum_values );

use constant ACCOUNT_PERFORMANCE_REPORT_TYPE => 'ACCOUNT_PERFORMANCE_REPORT';
use constant AD_PERFORMANCE_REPORT_TYPE => 'AD_PERFORMANCE_REPORT';
use constant CAMPAIGN_PERFORMANCE_REPORT_TYPE => 'CAMPAIGN_PERFORMANCE_REPORT';
use constant CRITERIA_PERFORMANCE_REPORT_TYPE => 'CRITERIA_PERFORMANCE_REPORT';
use constant CUSTOM_REPORT_TYPE => 'CUSTOM_REPORT';
use constant SEARCH_QUERY_PERFORMANCE_REPORT_TYPE => 'SEARCH_QUERY_PERFORMANCE_REPORT';
use constant ADGROUP_PERFORMANCE_REPORT_TYPE => 'ADGROUP_PERFORMANCE_REPORT';
use constant REACH_AND_FREQUENCY_PERFORMANCE_REPORT_TYPE => 'REACH_AND_FREQUENCY_PERFORMANCE_REPORT';
use constant STRATEGY_PERFORMANCE_REPORT_TYPE => 'STRATEGY_PERFORMANCE_REPORT';

our @REPORT_TYPES = (
    ACCOUNT_PERFORMANCE_REPORT_TYPE,
    ADGROUP_PERFORMANCE_REPORT_TYPE,
    AD_PERFORMANCE_REPORT_TYPE,
    CAMPAIGN_PERFORMANCE_REPORT_TYPE,
    CRITERIA_PERFORMANCE_REPORT_TYPE,
    CUSTOM_REPORT_TYPE,
    REACH_AND_FREQUENCY_PERFORMANCE_REPORT_TYPE,
    SEARCH_QUERY_PERFORMANCE_REPORT_TYPE,
    STRATEGY_PERFORMANCE_REPORT_TYPE
);

our @EXPORT_OK = qw(
    @REPORT_TYPES

    all_fields
    all_date_range_types
    AD_PERFORMANCE_REPORT_TYPE
    ACCOUNT_PERFORMANCE_REPORT_TYPE
    CAMPAIGN_PERFORMANCE_REPORT_TYPE
    CRITERIA_PERFORMANCE_REPORT_TYPE
    CUSTOM_REPORT_TYPE
    SEARCH_QUERY_PERFORMANCE_REPORT_TYPE
    ADGROUP_PERFORMANCE_REPORT_TYPE
    REACH_AND_FREQUENCY_PERFORMANCE_REPORT_TYPE
    STRATEGY_PERFORMANCE_REPORT_TYPE
);

=head2 %FIELD_NOT_AVAILABLE_IN_FIELD_NAMES

    Хэш, содержащий поля, недоступные в FieldNames для разных типов отчетов

=cut

our %FIELD_NOT_AVAILABLE_IN_FIELD_NAMES = (
    ADGROUP_PERFORMANCE_REPORT_TYPE() => {
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        GoalId => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    AD_PERFORMANCE_REPORT_TYPE() => {
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        GoalId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    ACCOUNT_PERFORMANCE_REPORT_TYPE() => {
        StrategyId => 1,
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        CampaignId => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    STRATEGY_PERFORMANCE_REPORT_TYPE() => {
        CampaignId => 1,
        CampaignName => 1,
        CampaignType => 1,
        CampaignUrlPath => 1,
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    CAMPAIGN_PERFORMANCE_REPORT_TYPE() => {
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        StrategyId => 1,
        DynamicTextAdTargetId => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    CRITERIA_PERFORMANCE_REPORT_TYPE() => {
        AdFormat => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        DynamicTextAdTargetId => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        StrategyId => 1,
        ImpressionReach => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    CUSTOM_REPORT_TYPE() => {
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    SEARCH_QUERY_PERFORMANCE_REPORT_TYPE() => {
        AdFormat => 1,
        AdNetworkType => 1,
        Age => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        CarrierType => 1,
        ClickType => 1,
        Device => 1,
        StrategyId => 1,
        DynamicTextAdTargetId => 1,
        ExternalNetworkName => 1,
        Gender => 1,
        ImpressionShare => 1,
        Keyword => 1,
        LocationOfPresenceId => 1,
        LocationOfPresenceName => 1,
        MobilePlatform => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        Sessions => 1,
        Slot => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationId => 1,
        TargetingLocationName => 1,
        AttributionModel => 1,
    },
    REACH_AND_FREQUENCY_PERFORMANCE_REPORT_TYPE() => {
        AdFormat => 1,
        AdNetworkType => 1,
        AvgClickPosition => 1,
        AvgImpressionPosition => 1,
        AudienceTargetId => 1,
        CarrierType => 1,
        ClickType => 1,
        Criteria => 1,
        CriteriaId => 1,
        CriteriaType => 1,
        Criterion => 1,
        CriterionId => 1,
        CriterionType => 1,
        StrategyId => 1,
        DynamicTextAdTargetId => 1,
        ExternalNetworkName => 1,
        ImpressionShare => 1,
        Keyword => 1,
        LocationOfPresenceId => 1,
        LocationOfPresenceName => 1,
        MatchType => 1,
        MatchedKeyword => 1,
        MobilePlatform => 1,
        Placement => 1,
        Query => 1,
        RlAdjustmentId => 1,
        Slot => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingCategory => 1,
        IncomeGrade => 1,
    },
);

=head2 %FIELD_NOT_AVAILABLE_IN_FILTER

    Хэш, содержащий поля, недоступные в Filter.Field для разных типов отчетов

=cut

our %FIELD_NOT_AVAILABLE_IN_FILTER = (
    ADGROUP_PERFORMANCE_REPORT_TYPE() => {
        AdId => 1,
        AdGroupName => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        DynamicTextAdTargetId => 1,
        GoalId => 1,
        Keyword => 1,
        LocationOfPresenceName => 1,
        MatchedKeyword => 1,
        Month => 1,
        Query => 1,
        Quarter => 1,
        Sessions => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    AD_PERFORMANCE_REPORT_TYPE() => {
        AdGroupName => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        DynamicTextAdTargetId => 1,
        GoalId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        LocationOfPresenceName => 1,
        MatchedKeyword => 1,
        Month => 1,
        Quarter => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        Sessions => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    ACCOUNT_PERFORMANCE_REPORT_TYPE() => {
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        Bounces => 1,
        AudienceTargetId => 1,
        CampaignId => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        LocationOfPresenceName => 1,
        MatchedKeyword => 1,
        Month => 1,
        Keyword => 1,
        Query => 1,
        Quarter => 1,
        Sessions => 1,
        StrategyId => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    STRATEGY_PERFORMANCE_REPORT_TYPE() => {
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Bounces => 1,
        CampaignId => 1,
        CampaignName => 1,
        CampaignType => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        DynamicTextAdTargetId => 1,
        LocationOfPresenceName => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Month => 1,
        Quarter => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        Sessions => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    CAMPAIGN_PERFORMANCE_REPORT_TYPE() => {
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        DynamicTextAdTargetId => 1,
        LocationOfPresenceName => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Month => 1,
        Quarter => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        Sessions => 1,
        StrategyId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    CRITERIA_PERFORMANCE_REPORT_TYPE() => {
        AdFormat => 1,
        AdId => 1,
        AdGroupName => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        LocationOfPresenceName => 1,
        MatchedKeyword => 1,
        Month => 1,
        Query => 1,
        Quarter => 1,
        ImpressionReach => 1,
        Sessions => 1,
        StrategyId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    CUSTOM_REPORT_TYPE() => {
        AdGroupName => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        ImpressionShare => 1,
        LocationOfPresenceName => 1,
        MatchedKeyword => 1,
        Month => 1,
        Query => 1,
        Quarter => 1,
        ImpressionReach => 1,
        Sessions => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    SEARCH_QUERY_PERFORMANCE_REPORT_TYPE() => {
        AdFormat => 1,
        AdGroupName => 1,
        AdNetworkType => 1,
        Age => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        CarrierType => 1,
        ClickType => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Date => 1,
        Device => 1,
        ExternalNetworkName => 1,
        Gender => 1,
        ImpressionShare => 1,
        LocationOfPresenceId => 1,
        LocationOfPresenceName => 1,
        MobilePlatform => 1,
        Month => 1,
        Quarter => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        Sessions => 1,
        Slot => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        StrategyId => 1,
        TargetingLocationId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
    },
    REACH_AND_FREQUENCY_PERFORMANCE_REPORT_TYPE() => {
        AdGroupName => 1,
        AdFormat => 1,
        AdNetworkType => 1,
        AvgClickPosition => 1,
        AvgImpressionPosition => 1,
        AudienceTargetId => 1,
        Bounces => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        CarrierType => 1,
        ClickType => 1,
        Criteria => 1,
        CriteriaId => 1,
        CriteriaType => 1,
        Criterion => 1,
        CriterionId => 1,
        CriterionType => 1,
        Date => 1,
        DynamicTextAdTargetId => 1,
        ExternalNetworkName => 1,
        ImpressionShare => 1,
        Keyword => 1,
        LocationOfPresenceId => 1,
        LocationOfPresenceName => 1,
        MatchType => 1,
        MatchedKeyword => 1,
        MobilePlatform => 1,
        Month => 1,
        Quarter => 1,
        Placement => 1,
        Sessions => 1,
        Query => 1,
        RlAdjustmentId => 1,
        Slot => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        StrategyId => 1,
        TargetingLocationName => 1,
        Week => 1,
        Year => 1,
        TargetingCategory => 1,
        IncomeGrade => 1,
    },
);

=head2 %FIELD_NOT_AVAILABLE_IN_ORDER_BY

    Хэш, содержащий поля, недоступные в OrderBy.Field для разных типов отчетов

=cut

our %FIELD_NOT_AVAILABLE_IN_ORDER_BY = (
    ADGROUP_PERFORMANCE_REPORT_TYPE()  => {
        StrategyId             => 1,
        AdId                   => 1,
        AvgCpm                 => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        GoalId => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    AD_PERFORMANCE_REPORT_TYPE()       => {
        AvgCpm                 => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        GoalId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    ACCOUNT_PERFORMANCE_REPORT_TYPE()  => {
        StrategyId             => 1,
        AdGroupId              => 1,
        AdGroupName            => 1,
        AdId                   => 1,
        AvgCpm                 => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        CampaignId => 1,
        CampaignName => 1,
        CampaignUrlPath => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    STRATEGY_PERFORMANCE_REPORT_TYPE() => {
        CampaignName => 1,
        CampaignType => 1,
        CampaignId => 1,
        CampaignUrlPath => 1,
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        LocationOfPresenceId => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    CAMPAIGN_PERFORMANCE_REPORT_TYPE() => {
        StrategyId => 1,
        AdGroupId => 1,
        AdGroupName => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        LocationOfPresenceId => 1,
        Query => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    CRITERIA_PERFORMANCE_REPORT_TYPE() => {
        StrategyId => 1,
        AdFormat => 1,
        AdId => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Placement => 1,
        Query => 1,
        ImpressionReach => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    CUSTOM_REPORT_TYPE() => {
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        DynamicTextAdTargetId => 1,
        ImpressionShare => 1,
        Keyword => 1,
        MatchedKeyword => 1,
        Query => 1,
        ImpressionReach => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        AttributionModel => 1,
    },
    SEARCH_QUERY_PERFORMANCE_REPORT_TYPE() => {
        StrategyId => 1,
        AdFormat => 1,
        AdNetworkType => 1,
        Age => 1,
        AvgCpm => 1,
        AvgImpressionFrequency => 1,
        AudienceTargetId => 1,
        CarrierType => 1,
        ClickType => 1,
        Criteria => 1,
        CriteriaId => 1,
        Criterion => 1,
        CriterionId => 1,
        Device => 1,
        DynamicTextAdTargetId => 1,
        ExternalNetworkName => 1,
        Gender => 1,
        ImpressionShare => 1,
        Keyword => 1,
        LocationOfPresenceId => 1,
        LocationOfPresenceName => 1,
        MobilePlatform => 1,
        ImpressionReach => 1,
        RlAdjustmentId => 1,
        Sessions => 1,
        Slot => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingLocationId => 1,
        TargetingLocationName => 1,
        AttributionModel => 1,
    },
    REACH_AND_FREQUENCY_PERFORMANCE_REPORT_TYPE() => {
        StrategyId => 1,
        AdFormat => 1,
        AdNetworkType => 1,
        AvgClickPosition => 1,
        AvgImpressionPosition => 1,
        AudienceTargetId => 1,
        CarrierType => 1,
        ClickType => 1,
        Criteria => 1,
        CriteriaId => 1,
        CriteriaType => 1,
        Criterion => 1,
        CriterionId => 1,
        CriterionType => 1,
        DynamicTextAdTargetId => 1,
        ExternalNetworkName => 1,
        ImpressionShare => 1,
        Keyword => 1,
        LocationOfPresenceId => 1,
        LocationOfPresenceName => 1,
        MatchType => 1,
        MatchedKeyword => 1,
        MobilePlatform => 1,
        Placement => 1,
        Query => 1,
        RlAdjustmentId => 1,
        Slot => 1,
        SmartBannerFilterId => 1,
        SmartAdTargetId => 1,
        TargetingCategory => 1,
        IncomeGrade => 1,
    },
);

=head2 all_fields

Все поля, перечисленные в reports.xsd в FieldEnum. В FieldNames и Filter можно
использовать только некоторые из них; какие нельзя использовать в FieldNames,
см. %FIELD_NOT_AVAILABLE_IN_FIELD_NAMES.

=cut

sub all_fields {
    return get_enum_values( 'reports', 'FieldEnum' );
}

=head2 all_date_range_types

Все варианты в reports.xsd в DateRangeTypeEnum.

=cut

sub all_date_range_types {
    return get_enum_values( 'reports', 'DateRangeTypeEnum' );
}

1;
