package API::Units::Bucket;

use Direct::Modern;

=pod

=encoding utf8

    $Id: $

=head1 NAME

    API::Units::Bucket

=head1 SYNOPSIS

    my $bucket = API::Units::Bucket->new(id => $user->client_id, limit => 10_000, owner_login => $user->login);

=head1 DESCRIPTION

    Данные, необходимые для списания баллов - id корзины, лимит баллов и логин владельца.

=head1 METHODS

=cut

use Mouse;

=head2 id

    Id корзины с баллами

=cut

has id => (
    is => 'ro',
    isa => 'Int',
    required => 1,
);

=head2 limit

    Лимит баллов в корзине

=cut

has limit => (
    is => 'ro',
    isa => 'Int',
    required => 1,
);

=head2 owner_login

    Логин владельца корзины

=cut

has owner_login => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

1;
