package API::Units::FreeOfChargeRoles;

use Direct::Modern;

=pod

=encoding utf8

    $Id:$

=head1 NAME

    API::Units::FreeOfChargeRoles

=head1 SYNOPSIS

    UnitsFactory::create($subclient_id)->withdraw(10) unless API::Units::FreeOfChargeRoles::is_free_role($operator_user_role)

=head1 DESCRIPTION

    Модуль реализует кусок бизнес логики о том, что с некоторых ролей оператора
    мы не списываем балы с сабклиента. Пример если менеджер работает с данными
    клиента, с клиента не надо списывать баллы. При этом если с сабклиентом
    работает агенство, баллы с клиента списывать надо.

=head1 METHODS

=head2 is_free_role($role)

    $role - роль оператора строкой

=cut

use RBACElementary qw/rbac_is_internal_user/;

sub is_free_role {
    my $role = shift;
    return rbac_is_internal_user(undef, role => $role) ? 1 : 0;
}

1;

__END__
