package API::WSDL::ErrorsTranslation;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    API::WSDL::ErrorsTranslation

=head1 SYNOPSIS

    use API::WSDL::ErrorsTranslation;

=head1 DESCRIPTION

    При подключении модуль транслирует ошибки XML::Compile в ошибки API

=head1 METHODS

=cut


use Yandex::I18n;
use Direct::Errors::Messages;

use Log::Report;

dispatcher filter => sub {
    my ($dispatcher, $opts, $reason, $message, $domain) = @_;
    if($domain eq 'xml-compile') {
        return on_xml_compile_error($reason => $message);
    }
    return ($reason, $message);
}, 'default';


=head2 on_xml_compile_error($reason, $message)

    Получаем сообщение об ошибке формата Log::Report из XML::Compile отдаем его
    же, в случае если ошибку нужно подменить -- делаем die с соответствующей
    ошибкой Direct::Defect, которая будет поймана выше по коду

    Ошибки XML::LibXML::Error сюда не попадают

=cut

sub on_xml_compile_error {
    my ($reason, $message) = @_;

    my $msgid = $message->msgid;
    if($msgid eq 'tag `{tags}\' not used at {path}') {
        my $tag = $message->valueOf('tags')->[0];
        die error_BadRequest( iget('Неверный параметр %s', _path_cut($tag)) );
    } elsif ( $msgid eq 'element `{name}\' not processed for {path} at {where}') {
        my $name = $message->valueOf('name');
        die error_BadRequest( iget('Неверный параметр %s', $name) );
    } elsif ( $msgid eq 'illegal value `{value}\' for type {type} at {path}' ) {
        die error_BadRequest( iget('Неверное значение тэга %s, допустимы значения типа %s',
            _message_params($message, qw/path type/)
        ));
    } elsif ( $msgid eq 'required value for element `{tag}\' missing at {path}') {
        die error_BadRequest( iget('В %s отсутствует обязательное поле %s',
            _message_params($message, qw/path tag/)
        ));
    } elsif ( $msgid eq 'data for element or block starting with `{tag}\' missing at {path}') {
        die error_BadRequest( iget('В %s отсутствует обязательное поле %s',
            _message_params($message, qw/path tag/)
        ));
    } elsif ( $msgid eq 'invalid enumerate `{string}\' at {where}' ) {
        die error_BadRequest( iget('%s содержит неверное значение перечисления',
            _message_params($message, 'where')
        ));
    } else {
        warn "unrecognized xml-compile message \`$msgid'";
        die error_BadRequest('');
    }

    return ($reason, $message);
}

sub _message_params {
    my ($message, @params) = @_;
    return map { _path_cut( $message->valueOf($_) ) } @params;
}

# {http://api.direct.yandex.com/v5/adgroups}GetRequest/SelectionCriteria/Ids => Ids
sub _path_cut { _path_last_node( _remove_ns($_[0]) ) }

# {http://api.direct.yandex.com/v5/adgroups}GetRequest/SelectionCriteria/Ids => GetRequest/SelectionCriteria/Ids
sub _remove_ns {
    my $full_path = shift;
    $full_path =~ s/\#facet//;
    $full_path =~ s/^\{(.+)\}//;
    $full_path =~ s/^.*://;
    return $full_path;
}

# GetRequest/SelectionCriteria/Ids => Ids
sub _path_last_node {
    my $path = shift;
    if($path =~ /\/([^\/]+)$/) {
        return $1;
    }
    return $path;
}

1;

__END__
