package Campaign::Creator::Types;

use Direct::Modern;
=pod

=encoding utf8

    $Id:$

=head1 NAME

    Campaign::Creator::Types

=head1 SYNOPSIS

    use Campaign::Creator::Types;

=head1 DESCRIPTION

    Модуль с типами для Campaing::Creator, вынесено в отдельный файл иначе
    compile_all.t взрывается от 'no Mouse::Util::TypeConstraints',
    и из-за этого его нужно выключить, делать это для модуля с логикой нельзя.

=head1 Types

=head2 RBACRoles

    Enum ролей RBAC, см. RBACDirect.pm

=head2 CreateCheckResult

    хэш с полями error, create_by_role, create_by_agency_uid

=cut

use RBACDirect;

use Mouse::Util::TypeConstraints;

enum 'RBACRoles' => (keys %RBACDirect::ROLE_NAMES); # qw(client agency manager);

type 'CreateCheckResult' => where {
    ref $_ eq 'HASH'
    && (keys %$_) == 3
    && exists $_->{error}
    && exists $_->{create_by_role}
    && exists $_->{create_by_agency_uid}
};

no Mouse::Util::TypeConstraints;

1;
