package Plack::Middleware::Dumper;

use strict;
use warnings;
use utf8;

=pod

    $Id$

=head1 NAME

    Plack::Middleware::Dumper;

=head1 SYNOPSIS

    package SomePlackApp;

    use Plack::Builder;
    use Plack::Middleware::Dumper;

    sub get_app {
        my $app = sub {
            return "ok";
        }

        return builder {
            enable 'Plack::Middleware::Dumper';
            $app;
        };

    }


=head1 DESCRIPTION

    Plack middleware для дампа запросов и ответов к и от приложения в STDERR

=head1 METHODS

=head2 call($self,$env)

    Вызываем приложение и возвращает результат без изменений. Запрос и ответ дампятся в STDERR

=cut

use JSON;
use Encode;

use base 'Plack::Middleware';

my $JSON = JSON->new->utf8;

sub call {
    my($self, $env) = @_;

    my $r = Plack::UTF8Request->new($env);
    warn "REQUEST: " . $r->headers->as_string . decode_utf8($r->content);

    my $res = $self->app->($env);

    my %headers = @{$res->[1]};

    warn "RESPONSE: headers => " . $JSON->encode(\%headers) . "\n" . decode_utf8(join("\n", @{$res->[2]}));

    return $res;
}

1;

__END__
