package WSDL::JSON::Schema::Sequence;

use Direct::Modern;

=pod

    $Id$

=head1 NAME

    WSDL::JSON::Schema::Sequence

=head1 SYNOPSIS

    my $sequence = WSDL::JSON::Schema::Sequence;
    $sequence->add($name, $element);
    $sequence->element_names; # @names

    $sequence->element($name); $element

=head1 DESCRIPTION

    Класс для добавления к хэшу сортированного, в порядке добавления, списка
    ключей, нужно чтобы привалидации мы всегда обходили ключи в одном и том же
    порядке

=head1 METHODS

=cut

use Mouse;

=head2 name

    Имя типа, всегда sequence

=cut

has name => (is => 'rw', isa => 'Str', default => 'sequence');

# из соображений производительности можно использовать напрямую
has elements => (is => 'rw', isa => 'HashRef', default => sub { {} } );

=head2 element_names

    Список имен элементов в том порядке в котором они добавлялись

=cut

has element_names => (is => 'rw', isa => 'ArrayRef', default => sub { [] }, auto_deref => 1 );

=head2 add($name, $element)

    Добавляем элемент хэша с именем $name

=cut

sub add {
    my ($self, $name, $element) = @_;
    push @{ $self->element_names }, $name;
    $self->elements->{$name} =  $element;
    return;
}

=head2 element($name)

    Элемент по имени

=cut

sub element { $_[0]->elements->{$_[1]} }

=head2 has_element($name)

    Возращает true если элемент с таким именем добавлен

=cut

sub has_element { exists $_[0]->elements->{$_[1]} ? 1 : 0 }

__PACKAGE__->meta->make_immutable;

1;

__END__
