use strict;
use warnings;

use lib::abs "./../../lib";
use lib::abs "./../../services/v5";

use API::PSGI::JSON;
use API::PSGI::Reports::JSON;

# to check http://127.0.0.1:$BETA/json/v5/keywords
my $json_app = API::PSGI::JSON->get_app;
# to check http://127.0.0.1:$BETA/json/v5/reports
my $reports_json_app = API::PSGI::Reports::JSON->get_app;

my $app = sub {
    my ($env) = @_;

    my @uri_components = split m{/}, $env->{REQUEST_URI};

    if ( @uri_components && $uri_components[-1] eq 'reports' ) {
        return $reports_json_app->($env);
    }

    return $json_app->($env);
};
